/* ---------------------------------------------------------------------------
    2019 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

package pkcs;

public class Helper
{ 
	/**
    * Converts a ASCII string to binary byte array.
    *
    * @return binary byte array
    * @param theAsciiStr   ASCII string to be converted
    */
    public static byte [] convAsciiHexToBin (String theAsciiStr)
    {
        int nInLength;
        int i;

        if ((theAsciiStr == null) || (theAsciiStr.length() == 0))
        {
            return null;
        }

        nInLength = theAsciiStr.length();
        /* data len must be even */
        if ((nInLength % 2) != 0)
        {
            return null;
        }

        byte[] theRes = new byte[nInLength / 2];

        for (i = 0; i < nInLength; i += 2)
        {
            theRes[i / 2] = (byte)(int)(Character.digit(theAsciiStr.charAt(i), 16) * 16 +
                            Character.digit(theAsciiStr.charAt(i+1), 16));
        }

        return theRes;
    }
    
    /**
     * Converts a ASCII string to binary byte array.
     *
     * @return binary byte array
     * @param theAsciiStr   ASCII string to be converted
     */
     public static String convAsciiBinToString(byte [] byteArray)
     {
         int nInLength;
         int i;

         if ((byteArray == null) || (byteArray.length == 0))
         {
             return null;
         }

         nInLength = byteArray.length;

         char[] theRes = new char[nInLength];

         for (i = 0; i < nInLength; i++)
         {
             theRes[i] = (char)byteArray[i];
         }

         return new String(theRes);
     }
    

	/**
    * Converts a byte into a character in hexadecimal.
    *
    */
	public static String byteToASCIIString(byte val)
	{
		String sTemp = new String("");
		
		switch(val)
		{
		case 0:
			sTemp = "0";
			break;
		case 1:
			sTemp = "1";
			break;
		case 2:
			sTemp = "2";
			break;
		case 3:
			sTemp = "3";
			break;
		case 4:
			sTemp = "4";
			break;
		case 5:
			sTemp = "5";
			break;
		case 6:
			sTemp = "6";
			break;
		case 7:
			sTemp = "7";
			break;
		case 8:
			sTemp = "8";
			break;
		case 9:
			sTemp = "9";
			break;
		case 10:
			sTemp = "A";
			break;
		case 11:
			sTemp = "B";
			break;
		case 12:
			sTemp = "C";
			break;
		case 13:
			sTemp = "D";
			break;
		case 14:
			sTemp = "E";
			break;
		case 15:
			sTemp = "F";
			break;
		} // end switch
		
		return sTemp;
	}
	
	/**
    * Converts a byte array to a readable string (in hexadecimal).
    *
    * @return String	the converted string
    * @param theArray 	the byte array to be converted
    */
	public static String byteArrayToASCIIString(byte[] theArray)
	{
	    String strMsg = new String("");
	    byte val;
	    if (theArray != null)
	    {
	        for (int i = 0 ; i < theArray.length ; i++)
	        {
	        	// The right shift operator '>>>' operates on integers. When the byte is converted into an int, 
	        	// it keeps its sign, thus introducing several 1s. That is why the bitmask 0xff must be applied.
	        	val = (byte) ((theArray[i] & 0xff) >>> 4);
	        	
	            strMsg += byteToASCIIString(val);
	            
	            val = (byte) (theArray[i] & 0xf);
	            
	            strMsg += byteToASCIIString(val);
	            
	            strMsg += ' ';
	        }
        }
        return strMsg;
    }
	
	/**
    * Copies an array into another array, shifted by an offset.
    *
    * @param DestArray   the destination array
    * @param indexStartInDestArray   the index where the copy begins in the destination array
    * @param SrcArray	the source array
    */
	public static void copyArrays(byte [] DestArray, int indexStartInDestArray, byte[] SrcArray)
	{
		for (int i=0; i<SrcArray.length; i++)
		{
			DestArray[i+indexStartInDestArray] = SrcArray[i];
		}
	}
	
	public static boolean compareArrays(byte[] array1, byte[] array2)
	{
		if(array1.length != array2.length)
		{
			return false;
		}
		for(int i = 0; i < array1.length; i++)
		{
			if(array1[i] != array2[i])
			{
				return false;
			}
		}
		return true;
	}
	
}
